module openclose

// example program to illustrate dynamic closing and opening of controls

import StdEnv, StdIO

Start :: *World -> *World
Start world
	=	startIO 0 0 [initialise] [] world
where
	initialise ps
			= snd (openWindow 0 wdef ps)
	wdef	= Window "Window"
				(ListLS [control,control,control])
				//[	WindowId	wid
				[	WindowClose	(noLS closeProcess)
				,	WindowResize
				,	WindowSize	wsize
				,	WindowHMargin 0 0
				,	WindowVMargin 0 0
				,	WindowItemSpace 0 0
				]
	wsize	= {w=200,h=210}
	control	= CustomControl {w=wsize.w/3,h=20} look [ControlResize resize]
	resize curcsize oldwsize {w}
			//= {curcsize & w=w}
			= {curcsize & w=w/3}
	look _ {newFrame}
			= [	draw newFrame
			  ,	drawLine newFrame.corner1 newFrame.corner2
			  ,	drawLine {newFrame.corner1 & y=newFrame.corner2.y} {newFrame.corner2 & y=newFrame.corner1.y}
			  ]

